/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.iw.tasks.connectivity;

import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.HSCLocalizableMsg;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.iw.WizardTaskBean;
import com.ibm.hsc.iw.WizardTaskException;
import com.ibm.hsc.iw.tasks.connectivity.ConnectivityConstants;
import com.ibm.hsc.iw.tasks.connectivity.ConnectivityInit;
import com.ibm.hsc.iw.tasks.connectivity.ConnectivityState;
import com.ibm.hsc.iw.tasks.connectivity.ServiceAgreementResult;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import java.io.Serializable;

public class ConnectivityMainBean
extends WizardTaskBean
implements ConnectivityConstants {
    private static final String TRACE_MASKD = "JIWZCMBD";
    private static final String TRACE_MASKF = "JIWZCMBF";
    private static final String TRACE_MASKT = "JIWZCMBT";
    private String[] m_sConnectivityTypeSelection = new String[0];
    private ConnectivityState connectivityState = null;

    public ConnectivityMainBean(Object object) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->ConnectivityMainBean()");
        }
        ConnectivityInit connectivityInit = (ConnectivityInit)object;
        this.connectivityState = connectivityInit.getConnectivityState();
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--ConnectivityMainBean()");
        }
    }

    public void setConnectivityTypeSelection(String[] stringArray) throws IllegalUserDataException {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->setConnectivityTypeSelection()");
        }
        this.m_sConnectivityTypeSelection = stringArray;
    }

    public String[] getConnectivityTypeSelection() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->getConnectivityTypeSelection()");
        }
        return this.m_sConnectivityTypeSelection;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void load() {
    }

    public void prepare() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->prepare()");
        }
        String[] stringArray = new String[3];
        int n = 0;
        if (this.connectivityState.getPassThruPanelChecked()) {
            stringArray[n] = new String(this.getMountPrefix() + "PassThruGroup");
            if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "   prepare() - Passthru check being primed: " + stringArray[n]);
            }
            ++n;
        }
        if (this.connectivityState.getVPNPanelChecked()) {
            stringArray[n] = new String(this.getMountPrefix() + "VPNGroup");
            if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "   prepare() - VPN check being primed: " + stringArray[n]);
            }
            ++n;
        }
        if (this.connectivityState.getDialUpPanelChecked() || this.connectivityState.isInitialSelection() && n == 0) {
            stringArray[n] = new String(this.getMountPrefix() + "DialupGroup");
            if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "   prepare() - dialup check being primed: " + stringArray[n]);
            }
            ++n;
        }
        this.connectivityState.clearInitialSelection();
        this.m_sConnectivityTypeSelection = new String[n];
        for (int i = 0; i < n; ++i) {
            this.m_sConnectivityTypeSelection[i] = stringArray[i];
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--prepare()");
        }
    }

    public void panelAction(TaskActionEvent taskActionEvent) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->panelAction() : \n\tBean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + taskActionEvent.getCurrentElement() + "\n\tElementName   : " + taskActionEvent.getElementName() + "\n\tActionCommand : " + taskActionEvent.getActionCommand());
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "Unknown event received in panelAction(...).");
        }
        new AusMicrocodeLog(LOG_INFO_MAIN, 1).writeEntryFromTaskletClient();
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--panelAction(...)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable nextButtonHit() throws WizardTaskException {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->nextButtonHit()");
        }
        this.connectivityState.saveMainState(this.getConnectivityTypeSelection());
        if (this.connectivityState.getDialUpPanelChecked() || this.connectivityState.getVPNPanelChecked() || this.connectivityState.getPassThruPanelChecked()) {
            if (!this.connectivityState.getLicenseAgreementAccepted()) {
                this.display("com.ibm.hsc.iw.tasks.connectivity.res.ServiceAgreement", "ServiceAgreementPanel", "com.ibm.hsc.iw.tasks.connectivity.ServiceAgreementBean", (Serializable)this.connectivityState.getLicenseAgreement());
                ConnectivityMainBean connectivityMainBean = this;
                synchronized (connectivityMainBean) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this.connectivityState.getLicenseAgreementAccepted()) {
                    throw new WizardTaskException(null, null, false);
                }
            }
        } else if (!this.connectivityState.getWarningShown()) {
            this.connectivityState.setWarningShown();
            throw new WizardTaskException(new LocalizableText("com.ibm.hsc.common.bundles.ServiceAgentText", "INFO_TITLE"), new HSCLocalizableMsg(MsgType.INFORMATION_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "0429", null));
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--nextButtonHit()");
        }
        return this.connectivityState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayComplete(Serializable serializable) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-->displayComplete()");
        }
        ServiceAgreementResult serviceAgreementResult = (ServiceAgreementResult)serializable;
        if (3 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKD, "   displayComplete() - Service agreement display complete");
        }
        if (serviceAgreementResult.getServiceAgreementAccept()) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Service Agreement Accepted");
            }
            this.connectivityState.setLicenseAgreementAccepted();
        } else {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Service Agreement Declined");
            }
            this.m_sConnectivityTypeSelection = new String[0];
            this.userTaskManager.refreshAllElements();
        }
        ConnectivityMainBean connectivityMainBean = this;
        synchronized (connectivityMainBean) {
            this.notify();
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<--displayComplete()");
        }
    }

    public Serializable backButtonHit() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->backButtonHit()");
        }
        this.connectivityState.saveMainState(this.getConnectivityTypeSelection());
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--backButtonHit()");
        }
        return this.connectivityState;
    }
}

